#ifndef QRK_CONVERT_2D_H
#define QRK_CONVERT_2D_H

/*!
  \file
  \brief 距離データの 2D 変換

  \author Satofumi KAMIMURA

  $Id: convert2d.h 772 2009-05-05 06:57:57Z satofumi $
*/

#include "Point.h"
#include "Position.h"
#include <vector>


namespace qrk
{
  class RangeSensor;


  /*!
    \brief RangeSensor データの二次元平面への展開

    \param[out] points 変換後の点群データ
    \param[in] sensor 対象センサ
    \param[in] data 距離データ
    \param[in] offset 変換時のオフセット
    \param[in] max_length 変換を許す最大距離 (-1 指定で sensor の最大値を用いる)
  */
  void convert2d(std::vector<qrk::Point<long> >& points,
                 const RangeSensor* sensor, const std::vector<long>& data,
                 const qrk::Position<long>& offset,
                 int max_length = -1);


  /*!
    \overload
  */
  void convert2d(std::vector<qrk::Point<long> >& points,
                 const RangeSensor* sensor, const std::vector<long>& data,
                 int max_length = -1);
}

#endif /* !CONVERT_2D_H */
