/*!
  \file
  \brief URG のリセットサンプル

  \author Satofumi KAMIMURA

  $Id: reboot_urg.c 1300 2009-09-15 06:36:54Z satofumi $
*/

#include "urg_ctrl.h"
#include "delay.h"
#include <stdio.h>
#include <stdlib.h>


static void urg_exit(urg_t *urg, const char *message)
{
  printf("%s: %s\n", message, urg_error(urg));
  urg_disconnect(urg);

#ifdef MSC
  getchar();
#endif
  exit(1);
}


static void printVersion(urg_t *urg)
{
  enum {
    LinesMax = 5,
  };

  char buffer[LinesMax][UrgLineWidth];
  char *lines[LinesMax];
  int ret;
  int i;

  /* バージョン情報の取得 */
  for (i = 0; i < LinesMax; ++i) {
    lines[i] = buffer[i];
  }
  ret = urg_versionLines(urg, lines, LinesMax);
  if (ret < 0) {
    urg_exit(urg, "urg_getVersion");
  }

  /* 表示 */
  for (i = 0; i < LinesMax; ++i) {
    printf("%s\n", lines[i]);
  }
  printf("\n");
}


int main(int argc, char *argv[])
{
  enum {
    RebootTimes = 10,
    RebootMsec = 7000,         /* [msec] */
  };

  // const char device[] = "COM3"; /* Windows での例 */
  const char device[] = "/dev/ttyACM0"; /* Linux での例 */

  int ret;
  int i;

  urg_t urg;

  for (i = 0; i < RebootTimes; ++i) {
    ret = urg_connect(&urg, device, 115200);
    if (ret < 0) {
      urg_exit(&urg, "urg_connect()");
    }

    /* バージョン情報の表示 */
    printVersion(&urg);

    /* リセット */
    urg_reset(&urg);

    /* 再起動を待つ */
    delay(RebootMsec);
  }

  urg_disconnect(&urg);

  return 0;
}
