#ifndef QRK_RANGE_SENSOR_PARAMETER_H
#define QRK_RANGE_SENSOR_PARAMETER_H

/*!
  \file
  \brief レンジセンサのパラメータ管理

  \author Satofumi KAMIMURA

  $Id: RangeSensorParameter.h 1003 2009-06-14 07:24:58Z satofumi $
*/

#include <string>


namespace qrk
{
  /*!
    \brief センサパラメータ管理クラス
  */
  class RangeSensorParameter
  {
  public:
    enum {
      MODL = 0,                 //!< センサ型式情報
      DMIN,                     //!< 最小計測可能距離 [mm]
      DMAX,                     //!< 最大計測可能距離 [mm]
      ARES,                     //!< 角度分解能(360度の分割数)
      AMIN,                     //!< 最小計測可能方向値
      AMAX,                     //!< 最大計測可能方向値
      AFRT,                     //!< 正面方向値
      SCAN,                     //!< 標準操作角速度
    };

    std::string model;          //!< MODL 情報
    long distance_min;          //!< DMIN 情報
    long distance_max;          //!< DMAX 情報
    int area_total;             //!< ARES 情報
    int area_min;               //!< AMIN 情報
    int area_max;               //!< AMAX 情報
    int area_front;             //!< AFRT 情報
    int scan_rpm;               //!< SCAN 情報

    RangeSensorParameter(void)
      : model(""), distance_min(0), distance_max(0), area_total(0),
        area_min(0), area_max(0), area_front(0), scan_rpm(600)
    {
    }
  };
}

#endif /* !QRK_RANGE_SENSOR_PARAMETER_H */
