/*!
  \file
  \brief MD でのデータ取得サンプル

  \author Satofumi KAMIMURA

  $Id: md_capture.cpp 1148 2009-07-17 00:21:48Z satofumi $
*/

#include "UrgDevice.h"
#include "delay.h"
#include <iostream>
#include <cstdlib>

using namespace qrk;
using namespace std;


int main(int argc, char *argv[])
{
  const char device[] = "/dev/ttyACM0";

  UrgDevice urg;
  if (! urg.connect(device)) {
    cout << "UrgDevice::connect(): " << urg.what() << endl;
    exit(1);
  }

  enum { CaptureTimes = 10, };

  urg.setCaptureTimes(CaptureTimes);
  urg.setRequestMode(UrgDevice::MD_Capture);

  urg.requestData();
  size_t scan_msec = urg.scanMsec();

  for (size_t times = 0; times < CaptureTimes; ++times) {
    vector<long> data;
    long timestamp = 0;
    if (! urg.receiveData(data, &timestamp)) {
      delay(scan_msec);
      continue;
    }

    size_t n = data.size();

    cout << "n = " << n << ", ";
    cout << "timestamp = " << timestamp << ", ";
    cout << endl;
#if 0
    for (size_t i = 0; i < n; ++i) {
      cout << data[i] << ", ";
    }
    cout << endl;
#endif
  }

  // レーザを停止するとデータ取得は中断させる
  urg.laserOff();

  return 0;
}
