#ifndef QRK_URG_DISTANCE_H
#define QRK_URG_DISTANCE_H

/*!
  \file
  \brief UrgDevice に測定距離を保持させたクラス

  \author Satofumi KAMIMURA

  $Id: UrgDistance.h 1422 2009-10-18 13:48:05Z satofumi $
*/

#include "UrgDevice.h"


namespace qrk
{
  //! UrgDevice に測定距離を保持させたクラス
  class UrgDistance : public Coordinate, public RangeFinder
  {
  public:
    UrgDistance(void);
    ~UrgDistance(void);

    const char* what(void) const;
    bool connect(const char* device,
                 long baudrate = UrgDevice::DefaultBaudrate);
    void disconnect(void);
    bool isConnected(void) const;
    void setConnection(Connection* connection);
    Connection* connection(void);
    size_t scanMsec(void) const;
    size_t minDistance(void) const;
    size_t maxDistance(void) const;
    size_t maxRange(void) const;
    //void setTimestamp(long timestamp);
    void setCaptureTimes(size_t times);
    void setCaptureRange(size_t begin_index, size_t end_index);
    void setSkipLines(size_t skip_lines);

    void setRequestMode(UrgDevice::CaptureMode mode);
    void requestData(void);
    bool receiveData(std::vector<long>& data, long* timestamp);
    bool receiveData(void);
    long at(size_t index) const;

    size_t rad2index(double radian) const;
    double index2rad(size_t index) const;

    void laserOn(void);
    void laserOff(void);

  private:
    UrgDistance(const UrgDistance& rhs);
    UrgDistance& operator = (const UrgDistance& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;
  };
}

#endif /* !QRK_URG_DISTANCE_H */
