#ifndef SPLIT_LRF_DATA_H
#define SPLIT_LRF_DATA_H

/*!
  \file
  \brief LRF データの分割

  \author Satofumi KAMIMURA

  $Id: splitLrfData.h 1450 2009-10-25 21:15:53Z satofumi $
*/

#include "range_t.h"
#include <vector>


namespace qrk
{
  class RangeFinder;


  /*!
    \brief LRF データの分割

    ranges に登録された領域の隣の点にアクセスできるように、最初と最後の位置のデータは、ranges に含めない。
  */
  void splitLrfData(std::vector<range_t>& ranges,
                    const RangeFinder& lrf, std::vector<long>& data,
                    long threshold_mm = 100);
}

#endif /* !SPLIT_LRF_DATA_H */
