#ifndef QRK_DETECT_POLLS_H
#define QRK_DETECT_POLLS_H

/*!
  \brief 柱の検出

  \author Satofumi KAMIMURA

  $Id: detectPolls.h 1450 2009-10-25 21:15:53Z satofumi $
*/

#include "featurePoint_t.h"
#include "range_t.h"
#include <vector>

namespace qrk
{
  class RangeFinder;

  enum {
    PollsDefaultLength = -1,
  };


  void detectPolls(std::vector<featurePoint_t>& polls,
                   const RangeFinder& lrf,
                   const std::vector<long>& data,
                   const std::vector<range_t>& ranges,
                   long max_radius_mm = 300,
                   long min_length = PollsDefaultLength,
                   long max_length = PollsDefaultLength);
}

#endif /*! QRK_DETECT_POLLS_H */
