#ifndef QRK_DETECT_LINES_H
#define QRK_DETECT_LINES_H

/*!
  \file
  \brief 線分の検出

  \author Satofumi KAMIMURA

  $Id: detectLines.h 1450 2009-10-25 21:15:53Z satofumi $
*/

#include "line_t.h"
#include "range_t.h"
#include <vector>


namespace qrk
{
  class RangeFinder;

  enum {
    LinesDefaultLength = -1,
  };


  void detectLines(std::vector<line_t>& lines,
                   const RangeFinder& lrf,
                   const std::vector<long>& data,
                   const range_t& ranges,
                   long line_length_mm = 300,
                   long min_length = LinesDefaultLength,
                   long max_length = LinesDefaultLength);
}

#endif /* !QRK_DETECT_LINES_H */
