#ifndef QRK_LRF_DIRECTION_H
#define QRK_LRF_DIRECTION_H

/*!
  \file
  \brief RangeFinder を用いた向き推定

  \author Satofumi KAMIMURA

  $Id: LrfDirection.h 1450 2009-10-25 21:15:53Z satofumi $
*/

#include <vector>
#include <memory>


namespace qrk
{
  class RangeFinder;
  class Angle;


  /*!
    \brief RangeFinder を用いた向き推定
  */
  class LrfDirection
  {
  public:
    /*!
      \brief コンストラクタ

      \param[in] lrf RangeFinder オブジェクト

      \attention lrf とは接続しておく必要がある
    */
    LrfDirection(RangeFinder* lrf);

    ~LrfDirection(void);


    /*!
      \brief update() で探索する角度の設定

      \param[in] angle １回の update() で探索する角度
    */
    void setSearchAngle(const Angle& angle);


    /*!
      \brief データの更新

      \param[in] data 環境から測定した RangeFinder データ
    */
    void update(const std::vector<long>& data);


    /*!
      \brief 現在の推定角度を取得

      \return 推定角度
    */
    Angle direction(void) const;


    /*!
      \brief 推定角度の初期化

      \param[in] angle 推定角度の設定値
    */
    void setDirection(const Angle& angle);

  private:
    LrfDirection(void);
    LrfDirection(const LrfDirection& rhs);
    LrfDirection& operator = (const LrfDirection& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;
  };
}

#endif /* !QRK_LRF_DIRECTION_H */
