#ifndef QRK_PATH_SEARCH_H
#define QRK_PATH_SEARCH_H

/*!
  \file
  \brief 経路探索

  \author Satofumi KAMIMURA

  $Id: SearchPath.h 1414 2009-10-14 23:14:02Z satofumi $
*/

#include "Point.h"
#include <vector>
#include <memory>


namespace qrk
{
  /*!
    \brief 経路探索
  */
  class SearchPath
  {
  public:
    SearchPath(size_t width, size_t height);
    ~SearchPath(void);

    void clear(void);
    void setObstacle(long x, long y);
    void unsetObstacle(long x, long y);

    void setStart(long x, long y);
    void setGoal(long x, long y);

    void setOrigin(size_t x, size_t y);
    void setMagnify(int magnify);

    //! スタート位置からの相対経路を返す
    bool path(std::vector<Point<long> >& points) const;

  private:
    SearchPath(void);
    SearchPath(const SearchPath& rhs);
    SearchPath& operator = (const SearchPath& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;
  };
}

#endif /* !QRK_PATH_SEARCH_H */
