#ifndef QRK_FOLLOW_LINES_H
#define QRK_FOLLOW_LINES_H

/*!
  \file
  \brief 連続直線の追従モジュール

  \author Satofumi KAMIMURA

  $Id: FollowLines.h 1414 2009-10-14 23:14:02Z satofumi $
*/

#include "Point.h"
#include <vector>
#include <memory>


namespace qrk
{
  class Running;


  //! 連続直線の追従モジュール
  class FollowLines
  {
  public:
    FollowLines(const std::vector<Point<long> >& points, Running& running);
    ~FollowLines(void);


    /*!
      \brief 与えられた点列の経路を走行

      \retval true 経路を走行中
      \retval false 最後の点の走行が終了
    */
    bool run(void);


    void setPointIndex(size_t index);
    size_t pointIndex(void) const;

  private:
    FollowLines(void);
    FollowLines(const FollowLines& rhs);
    FollowLines& operator = (const FollowLines& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;
  };
}

#endif /* !QRK_FOLLOW_LINES_H */
