#ifndef QRK_SCIP_HANDLER_H
#define QRK_SCIP_HANDLER_H

/*!
  \file
  \brief SCIP 通信処理

  \author Satofumi KAMIMURA

  $Id: ScipHandler.h 1332 2009-09-23 01:04:31Z satofumi $
*/

#include "CaptureSettings.h"
#include <memory>
#include <vector>
#include <string>


namespace qrk
{
  class Connection;
  class RangeSensorParameter;


  /*!
    \brief SCIP プロトコルのハンドラ
  */
  class ScipHandler
  {
    ScipHandler(const ScipHandler& rhs);
    ScipHandler& operator = (const ScipHandler& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;

  public:
    static const bool Off = false;
    static const bool On = true;
    static const bool Force = true;

    ScipHandler(void);
    ~ScipHandler(void);

    const char* what(void) const;

    static long decode(const char* data, size_t size);
    static bool checkSum(const char* buffer, int size, char actual_sum);

    void setConnection(Connection* con);
    Connection* connection(void);

    // ボーレートを合わせた上でのデバイスとの接続
    bool connect(const char* device, long baudrate);

    int send(const char data[], int size);
    int recv(char data[], int size, int timeout);

    // URG デバイスからのパラメータの読み出し
    bool loadParameter(RangeSensorParameter& parameters);

    bool versionLines(std::vector<std::string>& lines);

    //! タイムスタンプのモードに遷移する
    bool setRawTimestampMode(bool on);

    bool rawTimestamp(int* timestamp);

    bool setLaserOutput(bool on, bool force = false);

    CaptureType receiveCaptureData(std::vector<long>& data,
                                   CaptureSettings& settings, long* timestamp,
                                   int* remain_times = NULL,
                                   int* total_times = NULL);
  };
}

#endif /* !QRK_SCIP_HANDLER_H */
