/*!
  \example viewSerialIdSample.cpp

  \brief シリアル ID の取得サンプル

  \author Satofumi KAMIMURA

  $Id: viewSerialIdSample.cpp 1437 2009-10-21 16:08:07Z satofumi $
*/

#include "UrgCtrl.h"
#include "UrgUtils.h"

using namespace qrk;


//! main
int main(int argc, char *argv[])
{
  const char device[] = "COM3";
  //const char device[] = "/dev/ttyACM0";

  UrgCtrl urg;
  if (! urg.connect(device)) {
    printf("UrgCtrl::connect: %s\n", urg.what());
    exit(1);
  }

  printf("Serial ID: %ld\n", urgSerialId<UrgCtrl>(&urg));

#ifdef MSC
  getchar();
#endif

  return 0;
}
