/*!
  \example viewPpSample.cpp

  \brief PP データ内容の表示

  \author Satofumi KAMIMURA

  $Id: viewPpSample.cpp 1437 2009-10-21 16:08:07Z satofumi $
*/

#include "UrgCtrl.h"
#include "RangeSensorParameter.h"
#include <cstdlib>

using namespace qrk;


//! main
int main(int argc, char *argv[])
{
  const char device[] = "COM3";
  //const char device[] = "/dev/ttyACM0";

  UrgCtrl urg;
  if (! urg.connect(device)) {
    printf("UrgCtrl::connect: %s\n", urg.what());
    exit(1);
  }

  // パラメータ情報の出力
  RangeSensorParameter parameters = urg.parameter();
  printf("model: %s\n", parameters.model.c_str());
  printf("distance_min: %ld\n", parameters.distance_min);
  printf("distance_max: %ld\n", parameters.distance_max);
  printf("area_total: %d\n", parameters.area_total);
  printf("area_min: %d\n", parameters.area_min);
  printf("area_max: %d\n", parameters.area_max);
  printf("area_front: %d\n", parameters.area_front);
  printf("scan_rpm: %d\n", parameters.scan_rpm);

#ifdef MSC
  getchar();
#endif

  return 0;
}
