/*!
  \example gdCaptureSample.cpp

  \brief GD コマンドによるデータ取得サンプル

  \author Satofumi KAMIMURA

  $Id: gdCaptureSample.cpp 1437 2009-10-21 16:08:07Z satofumi $
*/

#include "UrgCtrl.h"
#include <cstdlib>

using namespace qrk;
using namespace std;


//! main
int main(int argc, char *argv[])
{
  const char device[] = "COM3";
  //const char device[] = "/dev/ttyACM0";

  UrgCtrl urg;
  if (! urg.connect(device)) {
    printf("UrgCtrl::connect: %s\n", urg.what());
    exit(1);
  }

  // GD コマンドで指定された回数だけスキャンを行い、出力する
  enum { CaptureTimes = 1 };
  for (int i = 0; i < CaptureTimes; ++i) {
    long timestamp = 0;
    vector<long> data;

    // 取得
    int n = urg.capture(data, &timestamp);

    // 出力
    printf("timestamp: %ld\n", timestamp);
    for (int j = 0; j < n; ++j) {
      // urg_minDistance() 以下の距離データは、無効値を表す
      printf("%d:%ld, ", j, data[j]);
    }
    printf("\n");
  }

#ifdef MSC
  getchar();
#endif

  return 0;
}
