/*!
  \example partial_scan.c

  \brief 部分データの受信サンプル

  \author Satofumi KAMIMURA

  $Id: partial_scan.c 1299 2009-09-15 00:56:12Z satofumi $
*/

#include "urg_ctrl.h"
#include <stdio.h>
#include <stdlib.h>


static void urg_exit(urg_t *urg, const char *message)
{
  printf("%s: %s\n", message, urg_error(urg));
  urg_disconnect(urg);

#ifdef MSC
  getchar();
#endif
  exit(1);
}


int main(int argc, char *argv[])
{
  enum {
    BufferSize = 3,
  };

  //const char device[] = "COM3"; /* Windows での例 */
  const char device[] = "/dev/ttyACM0"; /* Linux での例 */

  long data[BufferSize];
  urg_parameter_t parameter;
  int first, last;
  int ret;
  int n;
  int i;

  /* 接続 */
  urg_t urg;
  ret = urg_connect(&urg, device, 115200);
  if (ret < 0) {
    urg_exit(&urg, "urg_connect()");
  }
  //urg_setSkipLines(&urg, 2);
  urg_parameters(&urg, &parameter);

  first = parameter.area_front_;
  last = first + BufferSize;

  /* 前方のみのデータ取得 */
  ret = urg_requestData(&urg, URG_GD, first, last);
  if (ret < 0) {
    urg_exit(&urg, "urg_requestData()");
  }

  /* 受信 */
  n = urg_receivePartialData(&urg, data, BufferSize, first, last);
  printf("# n = %d\n", n);
  if (n < 0) {
    urg_exit(&urg, "urg_receivePartialData()");
  }

  /* 表示 */
  for (i = 0; i < n; ++i) {
    /* urg_minDistance() 以下の距離データは、無効値を表す */
    printf("(%d: %ld), ", i, data[i]);
  }
  printf("\n");

  urg_disconnect(&urg);

#ifdef MSC
  getchar();
#endif

  return 0;
}
