#ifndef QRK_C_SERIAL_T_LIN_H
#define QRK_C_SERIAL_T_LIN_H

/*!
  \file
  \brief シリアル制御の構造体 (Linux, Mac 実装)

  \author Satofumi KAMIMURA

  $Id: serial_t_lin.h 1300 2009-09-15 06:36:54Z satofumi $
*/

#include <termios.h>


enum {
  SerialErrorStringSize = 256,
};


/*!
  \brief シリアル制御の構造体
*/
typedef struct {

  int errno_;                                /*!< エラー番号 */
  char error_string_[SerialErrorStringSize]; /*!< エラー文字列 */
  int fd_;                                   /*!< 接続リソース */
  struct termios sio_;                       /*!< ターミナル制御 */
  char has_last_ch_;            /*!< 書き戻した文字があるかのフラグ */
  char last_ch_;                             /*!< 書き戻した１文字 */

} serial_t;

#endif /*! QRK_C_SERIAL_T_LIN_H */
