-- 「まっすぐ走って止まる」サンプル

-- 接続
local run = mBeegoDrive()
if not run:connect("/dev/usb/ttyUSB0", 115200) then
   print("BeegoDrive::connect", run:what())
   return 1
end


----------------------------------------------------------------------
-- 車輪速を指定してまっすぐ走り、一定時間後に停止させる

for i = 0, 1 do
   -- 300 [mm/sec] で車輪を回転させる
   run:setWheelVelocity(i, 300)
end

-- ２秒だけ状態を維持
delay(2000)

-- 停止を指示
run:stop()

-- stop() は移動を開始するだけなので、完全に停止するまで少し待つ
delay(2000)


----------------------------------------------------------------------
-- 止まる位置が指定できる直線追従コマンドを使う

-- (1000, 0) の位置を通り、0 [deg] の方向に垂直な直線上で停止させる
run:stopLine(Position(1000, 0, deg(0)), nil)
while not run:isStable() do
   -- コマンドが安定状態になるまで待つ
   -- stopLine() の場合、指定位置で停止したときに、安定状態になる
   delay(100)
end
