#ifndef MOTOR_CONTROL_H
#define MOTOR_CONTROL_H

/*!
  \file
  \brief モータ制御

  \author Satofumi KAMIMURA

  $Id: motor_control.h 1209 2009-08-05 13:11:59Z satofumi $
*/

#include "motor_t.h"
#include "encoder_t.h"


extern void motor_initialize(int id, motor_t *motor);
extern void motor_reset(motor_t *motor);
extern void motor_setMode(int id, MotorMode mode);
extern void motor_setVelocity(int id, int count_per_msec,
                              int encoder_count, motor_t *motor);

#endif /* !MOTOR_CONTROL_H */
