#ifndef QRK_M_CAMERA_DEVICE_H
#define QRK_M_CAMERA_DEVICE_H

/*!
  \file
  \brief モニタ対応の CameraDevice クラス

  \author Satofumi KAMIMURA

  $Id: mCameraDevice.h 1414 2009-10-14 23:14:02Z satofumi $
*/

#include <memory>


namespace qrk
{
  class mCameraDevice
  {
  public:
    mCameraDevice(void);
    ~mCameraDevice(void);

    const char* what(void) const;

    bool connect(void);
    void disconnect(void);

    void setCaptureSize(int width, int height);
    bool capture(const char* file_name = "capture.jpg");

  private:
    mCameraDevice(const mCameraDevice& rhs);
    mCameraDevice& operator = (const mCameraDevice& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;
  };
}

#endif /* !QRK_M_CAMERA_DEVICE_H */
