/*!
  \file
  \brief Lua への Simulator 登録

  \author Satofumi KAMIMURA

  $Id: luabindSimulator.cpp 1364 2009-10-03 08:31:01Z satofumi $
*/

#include "luabindSimulator.h"
#include "BeegoDrive_device.h"
#include "UrgDevice_device.h"
#include "DeviceManager.h"
#include "CameraViewManager.h"

using namespace qrk;
using namespace luabind;


void qrk::luabindSimulator(lua_State* L)
{
  module(L)
    [
     class_<Device>("Device")
     .def("activate", &Device::activate),

     class_<OdeModel>("OdeModel")
     .def("setPosition", &OdeModel::setPosition)
     .def("position", &OdeModel::position)
     .def("setPosition3d", &OdeModel::setPosition3d)
     .def("position3d", &OdeModel::position3d),

     class_<BeegoDrive_device, Device, OdeModel>
     ("BeegoDrive_device")
     .def("activate", &BeegoDrive_device::activate)
     .def("setPosition", &BeegoDrive_device::setPosition)
     .def("position", &BeegoDrive_device::position)
     .def("setPosition3d", &BeegoDrive_device::setPosition3d)
     .def("position3d", &BeegoDrive_device::position3d),

     class_<UrgDevice_device, Device, OdeModel>("UrgDevice_device")
     .def("activate", &UrgDevice_device::activate)
     .def("setPosition", &UrgDevice_device::setPosition)
     .def("position", &UrgDevice_device::position)
     .def("setPosition3d", &UrgDevice_device::setPosition3d)
     .def("position3d", &UrgDevice_device::position3d),

     class_<DeviceManager>("DeviceManager")
     .def(constructor<>())
     .def("createDevice", &DeviceManager::createDevice)
     .def("createEvent", &DeviceManager::createEvent)
     .def("device", &DeviceManager::device)
     .def("model", &DeviceManager::model),

     class_<CameraViewManager>("CameraViewManager")
     .def(constructor<>())
     .def("setInitialView", &CameraViewManager::setInitialView)
     .def("setBaseView", &CameraViewManager::setBaseView)
     .def("setView", &CameraViewManager::setView)
     .def("setScale", &CameraViewManager::setScale)
     ];
}
