#ifndef QRK_EXECUTION_TYPE_H
#define QRK_EXECUTION_TYPE_H

/*!
  \file
  \brief 実行のタイプ管理

  \author Satofumi KAMIMURA

  $Id: ExecutionType.h 1414 2009-10-14 23:14:02Z satofumi $
*/

#include <memory>


namespace qrk
{
  //! 実行のタイプ管理
  class ExecutionType
  {
  public:
    typedef enum {
      RealDevice,               //!< 実機実行
      Recording,                //!< データを記録して実機実行
      Monitoring,               //!< シミュレーション画面を起動して実機実行

      Playback,                 //!< 記録されたデータを用いて実行
      Simulation,               //!< シミュレーション実行
    } Type;

    static ExecutionType* object(void);
    ~ExecutionType(void);

    void setType(Type type);
    Type type(void) const;

  private:
    ExecutionType(void);
    ExecutionType(const ExecutionType& rhs);
    ExecutionType& operator = (const ExecutionType& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;
  };
}

#endif /* !QRK_EXECUTION_TYPE_H */
