#ifndef QRK_CONVERT_2D_H
#define QRK_CONVERT_2D_H

/*!
  \file
  \brief Range Finder データの 2D 展開

  \author Satofumi KAMIMURA

  $Id: convert2d.h 1386 2009-10-09 08:00:11Z satofumi $
*/

#include "Position.h"
#include "Point.h"
#include <vector>


namespace qrk
{
  class RangeFinder;


  /*!
    \brief Range Finder データの 3D 位置への変換

    \param[out] points 変換後の点群
    \param[in] range_finder Range Finder
    \param[in] data Range Finder のデータ
    \param[in] offset 変換時のセンサ位置
  */
  void convert2d(std::vector<Point<long> >& points,
                 const RangeFinder& range_finder,
                 const std::vector<long>& data, const Position<long>& offset);
};

#endif /* !QRK_CONVERT_2D_H */
