#ifndef QRK_LOCK_GUARD_H
#define QRK_LOCK_GUARD_H

/*!
  \file
  \brief ロックガードクラス

  \author Satofumi KAMIMURA

  $Id: LockGuard.h 1414 2009-10-14 23:14:02Z satofumi $
*/

#include <memory>


namespace qrk
{
  class Lock;

  /*!
    \brief ロックガードクラス
  */
  class LockGuard
  {
  public:
    /*!
      \brief コンストラクタ

      \param[in] mutex ミューテックス資源
    */
    explicit LockGuard(qrk::Lock& mutex);
    ~LockGuard(void);

  private:
    LockGuard(void);
    LockGuard(const LockGuard& rhs);
    LockGuard& operator = (const LockGuard& rhs);

    void* operator new (size_t);
    void* operator new[] (size_t);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;
  };
}

#endif /* !QRK_LOCK_GUARD_H */
