#ifndef QRK_LOCK_H
#define QRK_LOCK_H

/*!
  \file
  \brief ロッククラス

  \author Satofumi KAMIMURA

  $Id: Lock.h 1424 2009-10-19 12:21:34Z satofumi $
*/

#include "ConditionVariable.h"


namespace qrk
{
  /*!
    \brief ロッククラス
  */
  class Lock
  {
  public:
    Lock(void);
    ~Lock(void);


    /*!
      \brief ロック
    */
    void lock(void);


    /*!
      \brief アンロック
    */
    void unlock(void);

  private:
    friend class ConditionalVariable;
    friend bool ConditionVariable::wait(Lock* lock, int timeout);

    Lock(const Lock& rhs);
    Lock& operator = (const Lock& rhs);

    //void* operator new (size_t);
    //void* operator new[] (size_t);

    struct pImpl;
    const std::auto_ptr<pImpl> pimpl;
  };
}

#endif /* !QRK_LOCK_GUARD_H */
