#ifndef QRK_FEATURE_POINT_MAP_H
#define QRK_FEATURE_POINT_MAP_H

/*!
  \file
  \brief 特徴点から構成されるマップ

  \author Satofumi KAMIMURA

  $Id: FeaturePointMap.h 1414 2009-10-14 23:14:02Z satofumi $
*/

#include "featurePoint_t.h"
#include "Position.h"
#include "Point.h"
#include "Rect.h"
#include <vector>
#include <memory>


namespace qrk
{
  //! 特徴点の管理マップ
  class FeaturePointMap
  {
  public:
    FeaturePointMap(void);
    ~FeaturePointMap(void);


    /*!
      \brief 移動しているかを判定するバッファ数を設定

      \param[in] size バッファ数
    */
    void setBufferPeriod(size_t msec);


    /*!
      \brief データの更新

      \param[in] feature_points 環境から測定した特徴点
      \param[in] sensor_position 特徴点を観測したときのセンサの絶対座標系での位置
    */
    void update(const std::vector<featurePoint_t>& feature_points,
                const Position<long>& sensor_position, long timestamp);

    void setPosition(const Position<long>& position);

    //! 推定位置の取得
    Position<long> position(void) const;

    Position<long> velocity(void) const;

  private:
    FeaturePointMap(const FeaturePointMap& rhs);
    FeaturePointMap& operator = (const FeaturePointMap& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;
  };
}

#endif /* !QRK_FEATURE_POINT_MAP_H */
