#ifndef QRK_ANGLE_UTILS_H
#define QRK_ANGLE_UTILS_H

/*!
  \file
  \brief 角度の補助関数

  \author Satofumi KAMIMURA

  $Id: AngleUtils.h 1219 2009-08-14 02:59:46Z satofumi $
*/

#include "Angle.h"
#include "Point.h"
#include "MathUtils.h"


namespace qrk
{
  /*!
    \brief ３点がなす角の計算

    \todo 'なす角' を示す関数名に変更する
  */
  template <class T>
  Angle narrowAngle(const Point<T>& a, const Point<T>& b, const Point<T>& c)
  {
    double alpha = atan2(b.y - a.y, b.x- a.x);
    double beta = atan2(c.y - b.y, c.x- b.x);

    double theta = M_PI - (alpha - beta);
    while (theta < -M_PI) {
      theta += 2.0 * M_PI;
    }
    while (theta > M_PI) {
      theta -= 2.0 * M_PI;
    }

    return rad(theta);
  }


  /*!
    \brief 向きを計算する
  */
  template <class T>
  Angle lineDirection(const Point<T>& a, const Point<T>& b)
  {
    return rad(atan2(b.y - a.y, b.x - a.x));
  }
}

#endif /* !QRK_ANGLE_UTILS_H */
