/*!
  \file
  \brief GD スキャンサンプル

  GD コマンドを用いて、逐次の距離データ取得を行う

  \author Satofumi KAMIMURA

  $Id: gd_scan.c 776 2009-05-05 08:09:30Z satofumi $
*/

#include <stdio.h>
#include <stdlib.h>
#include "urg_ctrl.h"


static void urg_exit(urg_t *urg, const char *message) {

  printf("%s: %s\n", message, urg_error(urg));
  urg_disconnect(urg);

  exit(1);
}


//! main
int main(int argc, char *argv[]) {

  //const char device[] = "COM3"; /* Windows での例 */
  const char device[] = "/dev/ttyACM0"; /* Linux での例 */

  int data_max;
  long *data;
  int timestamp;
  int ret;
  int n;
  int i;

  /* 接続 */
  urg_t urg;
  ret = urg_connect(&urg, device, 115200);
  if (ret < 0) {
    printf("urg_connect: %s\n", urg_error(&urg));
    exit(1);
  }

  /* 受信バッファの確保 */
  data_max = urg_dataMax(&urg);
  fprintf(stderr, "data_max: %d\n", data_max);
  data = (long*)malloc(sizeof(long) * data_max);
  if (data == NULL) {
    perror("malloc");
    exit(1);
  }

  /* GD でのデータ要求 */
  ret = urg_requestData(&urg, URG_GD, URG_FIRST, URG_LAST);
  if (ret < 0) {
    urg_exit(&urg, "urg_requestData()");
  }

  /* データ取得 */
  n = urg_receiveData(&urg, data, data_max);
  printf("n = %d\n", n);
  if (n < 0) {
    urg_exit(&urg, "urg_receiveData()");
  }

  /* 表示 */
  timestamp = urg_recentTimestamp(&urg);
  printf("timestamp: %d\n", timestamp);
  for (i = 0; i < n; ++i) {
    printf("%d:%ld, ", i, data[i]);
  }
  printf("\n");

  urg_disconnect(&urg);
  free(data);

  return 0;
}
