/*!
  \file
  \brief チャットパケット処理の補助

  \author Satofumi KAMIMURA

  $Id: ChatPacketUtils.cpp 1000 2009-06-13 22:22:06Z satofumi $
*/

#include "ChatPacketUtils.h"
#include "PacketUtils.h"

using namespace qrk;


Packet qrk::chatPacket(const char* message, ClientId id)
{
  Packet packet;
  createPacketHeader(packet, "CH");

  addParameter(packet, id);
  addParameter(packet, message);
  packet.push_back(PacketControl::EndCharacter);
  setPacketLength(packet);

  return packet;
}


const char* qrk::chatMessage(const Packet& packet)
{
  return &packet[7];
}
