/*!
  \file
  \brief mUrgCtrl の動作サンプル

  \author Satofumi KAMIMURA

  $Id: mConnectionSample.cpp 992 2009-06-13 03:49:19Z satofumi $
*/

#include "mConnection.h"
#include "SerialDevice.h"
#include "ConnectionUtils.h"
#include "MonitorModeManager.h"

using namespace qrk;


int main(int argc, char *argv[])
{
  MonitorModeManager::object()->setMode(argc, argv);

  SerialDevice serial;
  mConnection connection(&serial);

  // 接続
  if (! connection.connect("/dev/ttyACM0", 19200)) {
    printf("SerialDevice::connect: %s\n", connection.what());
    exit(1);
  }

  // 文字列送信
  printf("--- send data ---\n");
  connection.send("V\r", 2);

  // 文字列受信
  printf("--- recv data ---\n");
  enum {
    BufferSize = 255,
    Timeout = 1000,
  };
  char buffer[BufferSize];
  while (1) {
    int recv_size = readline(&connection, buffer, BufferSize, Timeout);
    if (recv_size <= 0) {
      break;
    }
    printf("%s\n", buffer);
  }

  return 0;
}
