#ifndef QRK_M_USB_JOYSTICK_H
#define QRK_M_USB_JOYSTICK_H

/*!
  \file
  \brief モニタ対応の USB Joystick 制御

  \author Satofumi KAMIMURA

  $Id: mUsbJoystick.h 783 2009-05-05 08:56:26Z satofumi $
*/

#include <SDL.h>
#include <memory>


namespace qrk
{
  /*!
    \brief モニタ対応の USB Joystick 制御
  */
  class mUsbJoystick
  {
    mUsbJoystick(void);
    mUsbJoystick(const mUsbJoystick& rhs);
    mUsbJoystick& operator = (const mUsbJoystick& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;

  public:
    explicit mUsbJoystick(int argc, char *argv[]);
    ~mUsbJoystick(void);

    const char* what(void);

    size_t joystickNum(void);

    void setEvent(SDL_Event& event);

    enum {
      Auto = -1,           //!< 接続時に自動的にインデックスを選択する
    };

    bool connect(int index = Auto);
    void disconnect(void);
    bool isConnected(void);

    const char* productInfo(void);

    size_t numAxis(void);
    size_t numButtons(void);
    short axisValue(size_t index);
    bool isButtonPressed(size_t index);
  };
}

#endif /* !QRK_M_USB_JOYSTICK_H */
