#ifndef QRK_M_GPS_CTRL_H
#define QRK_M_GPS_CTRL_H

/*!
  \file
  \brief モニタ対応の GPS 制御

  \author Satofumi KAMIMURA

  $Id: mGpsCtrl.h 783 2009-05-05 08:56:26Z satofumi $
*/

#include "Gps.h"
#include <memory>


namespace qrk
{
  /*!
    \brief モニタ対応の GPS 制御
  */
  class mGpsCtrl : public Gps
  {
    mGpsCtrl(void);
    mGpsCtrl(const mGpsCtrl& rhs);
    mGpsCtrl& operator = (const mGpsCtrl& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;

  public:
    enum {
      DefaultBaudrate = 115200,
      NoTimeout = -1,
    };

    mGpsCtrl(int argc, char *argv[]);
    ~mGpsCtrl(void);

    const char* what(void) const;

    bool connect(const char* device, long baudrate = DefaultBaudrate);
    void setConnection(Connection* con);
    Connection* connection(void);
    void disconnect(void);
    bool isConnected(void);

    void update(NmeaData* nmea);
  };
}

#endif /* !QRK_M_GPS_CTRL_H */
