/*!
  \file
  \brief モニタ対応のカメラ制御

  \author Satofumi KAMIMURA

  $Id: mCameraDevice.cpp 1411 2009-10-14 21:13:36Z satofumi $
*/

#include "mCameraDevice.h"
#include "CameraDevice.h"

using namespace qrk;


struct mCameraDevice::pImpl
{
  CameraDevice camera;


  pImpl(int argc, char *argv[])
  {
    static_cast<void>(argc);
    static_cast<void>(argv);

    // !!! 未実装
  }
};


mCameraDevice::mCameraDevice(int argc, char *argv[])
  : pimpl(new pImpl(argc, argv))
{
}


mCameraDevice::~mCameraDevice(void)
{
}


const char* mCameraDevice::what(void)
{
  return pimpl->camera.what();
}


bool mCameraDevice::connect(void)
{
  return pimpl->camera.connect();
}


void mCameraDevice::disconnect(void)
{
  pimpl->camera.disconnect();
}


void mCameraDevice::setCaptureSize(int width, int height)
{
  pimpl->camera.setCaptureSize(width, height);
}


bool mCameraDevice::capture(const char* fileName)
{
  return pimpl->camera.capture(fileName);
}
