#ifndef QRK_GPS_SERVER_H
#define QRK_GPS_SERVER_H

/*!
  \file
  \brief シミュレータ用の GPS サーバ

  \author Satofumi KAMIMURA

  $Id: GpsServer.h 783 2009-05-05 08:56:26Z satofumi $
*/

#include "DeviceServer.h"
#include <memory>


namespace qrk
{
  /*!
    \brief シミュレータ用の GPS サーバ
  */
  class GpsServer : public DeviceServer
  {
    GpsServer(const GpsServer& rhs);
    GpsServer& operator = (const GpsServer& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;

  public:
    GpsServer(void);
    ~GpsServer(void);

    bool activate(long port);
    int updateInterval(void);
    void update(void);
  };
}

#endif /* !QRK_GPS_SERVER_H */
