/*!
  \example partial.cpp
  \brief 部分的に Lua スクリプトを利用するサンプル

  \author Satofumi KAMIMURA

  $Id: partial.cpp 935 2009-05-29 00:30:03Z satofumi $
*/

#include "LuaHandler.h"
#include "luabindInit.h"
#include <luabind/luabind.hpp>
#include <iostream>

using namespace qrk;
using namespace luabind;
using namespace std;


namespace
{
  void initilizeScript(lua_State* L)
  {
    // Lua の読み込みと実行を行う
    LuaHandler::dofile(L, "partial.lua");
  }


  void callScript(lua_State* L)
  {
    try {
      // Lua 関数内のコルーチンを処理する
      call_function<void>(L, "lua_function");

    } catch (const error &e) {
      static_cast<void>(e);
      cout << "lua_function(): " << lua_tostring(L, -1) << endl;
    }
  }
}


int main(int argc, char* argv[])
{
  static_cast<void>(argc);
  static_cast<void>(argv);

  lua_State* L = luabindInit();
  initilizeScript(L);

  for (int i = 0; i < 3; ++i) {
    cout << "C: " << (100 + i) << endl;
    callScript(L);
  }

  return 0;
}
