/*!
  \example bindCpp.cpp
  \brief C++ 関数をバインドするサンプル

  \author Satofumi KAMIMURA

  $Id: bindCpp.cpp 935 2009-05-29 00:30:03Z satofumi $
*/

#include "luabindSystem.h"
#include "luabindInit.h"
#include "LuaHandler.h"
#include <cstdlib>

using namespace qrk;


int main(int argc, char *argv[])
{
  if (argc <= 1) {
    printf("usage:\n"
           "\t%s <lua script>\n", argv[0]);
    exit(0);
  }
  const char* lua_script = argv[1];

  // C++ クラス、関数のバインド
  lua_State* L = luabindInit();
  luabindSystem(L);

  // １つ上のパスを Lua の実行パスに追加
  LuaHandler::addPath(L, "../?.lua\"");

  // 引数で渡されたスクリプトの実行
  return LuaHandler::dofile(L, lua_script);
}
