/*!
  \file
  \brief Lua への gui_sync (master) モジュール登録

  \author Satofumi KAMIMURA

  $Id: luabindSyncGui_master.cpp 940 2009-05-29 21:56:03Z satofumi $
*/

#include "luabindSyncGui_master.h"
#include "Component.h"
#include "MasterLayer.h"
#include "Color.h"
#include "master_ColorSurface.h"
#include "master_Label.h"
#include <luabind/luabind.hpp>

using namespace qrk;
using namespace qrk::sync_master;
using namespace luabind;


void qrk::luabindSyncGui_master(lua_State* L)
{
  module(L)
    [
     class_<MasterLayer>("MasterLayer")
     .def(constructor<>())
     .def("setAlpha", &MasterLayer::setAlpha)
     .def("draw", &MasterLayer::draw)
     .def("clear", &MasterLayer::clear)
     .def("push_front", &MasterLayer::push_front)
     .def("push_back", &MasterLayer::push_back)
     .def("remove", &MasterLayer::remove)
     .def("registerId", &MasterLayer::registerId),

     class_<ColorSurface, Surface>("ColorSurface")
     .def(constructor<const Rect<long>&, const Color&>())
     .def("rect", &ColorSurface::rect)
     .def("setAlpha", &ColorSurface::setAlpha)
     .def("draw", &ColorSurface::draw),

     class_<Label, Component>("Label")
     .def(constructor<Surface&>())
     .def("setPosition", &Label::setPosition)
     .def("position", &Label::position)
     ];
}
