/*!
  \file
  \brief Lua への gui モジュール登録

  \author Satofumi KAMIMURA

  $Id: luabindGui.cpp 940 2009-05-29 21:56:03Z satofumi $
*/

#include "luabindGui.h"
#include "LuaHandler.h"
#include "Screen.h"
#include "TextInput.h"
#include "EventUtils.h"
#include "LayerManager.h"
#include "Layer.h"
#include "Font.h"
#include "TextSurface.h"
#include "ColorSurface.h"
#include "ImageSurface.h"
#include "MultiSurface.h"
#include "Label.h"
#include "Button.h"
#include "Menu.h"
#include "ChatMessage.h"
#include "CallbackEvent.h"
#include "AlignUtils.h"
#include <luabind/luabind.hpp>

using namespace qrk;
using namespace luabind;


void qrk::luabindGui(lua_State* L)
{
  module(L)
    [
     class_<Screen>("Screen")
     .def(constructor<>())
     .def("rect", &Screen::rect)
     .def("isFullscreen", &Screen::isFullscreen)
     .def("toggleScreen", &Screen::toggleScreen)
     .def("showCursor", &Screen::showCursor)
     .def("isShowCursor", &Screen::isShowCursor)
     .def("setClearColor", &Screen::setClearColor)
     .def("clear", &Screen::clear),

     class_<Event>("Event"),

     class_<CallbackEvent, Event>("CallbackEvent")
     .def(constructor<>())
     .def("clearEvent", &CallbackEvent::clearEvent)
     .def("key", &CallbackEvent::key)
     .def("click", &CallbackEvent::click)
     .def("enterCursor", &CallbackEvent::enterCursor)
     .def("moveCursor", &CallbackEvent::moveCursor)
     .def("isActive", &CallbackEvent::isActive)
     .def("setCallback", &CallbackEvent::setCallback),

     class_<TextInput, Event>("TextInput")
     .def(constructor<>())
     .def("clear", &TextInput::clear)
     .def("empty", &TextInput::empty)
     .def("text", &TextInput::text)
     .def("isChanged", &TextInput::isChanged)
     .def("setBackspaceEvent", &TextInput::setBackspaceEvent)
     .def("setDecideEvent", &TextInput::setDecideEvent),

     def("setQuitEvent", &setQuitEvent),
     def("setEnterEvent", &setEnterEvent),

     class_<LayerManager>("LayerManager")
     .def(constructor<>())
     .def("updateEvent", &LayerManager::updateEvent)
     .def("draw", &LayerManager::draw)
     .def("swap", &LayerManager::swap)
     .def("clearEvent", &LayerManager::clearEvent)
     .def("insertEvent", &LayerManager::insertEvent)
     .def("removeEvent", &LayerManager::removeEvent)
     .def("clear", &LayerManager::clear)
     .def("push_front", &LayerManager::push_front)
     .def("push_back", &LayerManager::push_back)
     .def("remove", &LayerManager::remove),

     class_<LayerInterface>("LayerInterface"),

     class_<Layer, LayerInterface>("Layer")
     .def(constructor<>())
     .def("clear", &Layer::clear)
     .def("push_front", &Layer::push_front)
     .def("push_back", &Layer::push_back)
     .def("remove", &Layer::remove)
     .def("setAlpha", &Layer::setAlpha)
     .def("draw", &Layer::draw),

     class_<Font>("Font")
     .def(constructor<const char*, size_t, bool>())
     .def("duplicate", &Font::duplicate)
     .def("isValid", &Font::isValid)
     .def("setFontSize", &Font::setFontSize)
     .def("fontSize", &Font::fontSize)
     .def("setForegroundColor", &Font::setForegroundColor)
     .def("foregroundColor", &Font::foregroundColor)
     .def("setBackgroundColor", &Font::setBackgroundColor)
     .def("backgroundColor", &Font::backgroundColor)
     .def("setTransparent", &Font::setTransparent)
     .def("transparent", &Font::transparent),

     class_<Surface>("Surface"),

     class_<TextSurface, Surface>("TextSurface")
     .def(constructor<const Font&, const char*>())
     .def("rect", &TextSurface::rect)
     .def("setAlpha", &TextSurface::setAlpha)
     .def("draw", &TextSurface::draw),

     class_<ColorSurface, Surface>("ColorSurface")
     .def(constructor<const Rect<long>&, const Color&>())
     .def("rect", &ColorSurface::rect)
     .def("setAlpha", &ColorSurface::setAlpha)
     .def("draw", &ColorSurface::draw),

     class_<ImageSurface, Surface>("ImageSurface")
     .def(constructor<const char*, bool>())
     .def("rect", &ImageSurface::rect)
     .def("setAlpha", &ImageSurface::setAlpha)
     .def("draw", &ImageSurface::draw),

     class_<MultiSurface, Surface>("MultiSurface")
     .def(constructor<Surface&>())
     .def("rect", &MultiSurface::rect)
     .def("setAlpha", &MultiSurface::setAlpha)
     .def("draw", &MultiSurface::draw)
     .def("push_front", &MultiSurface::push_front),

     class_<Component>("Component"),

     class_<Label, Component>("Label")
     .def(constructor<Surface&>())
     .def("setPosition", &Label::setPosition)
     .def("position", &Label::position),

     class_<Button, Component>("Button")
     .def(constructor<Surface&, Surface&, Surface&>()),

     class_<Menu, Component>("Menu")
     .enum_("Align")
     [
      value("Left", Menu::Left),
      value("Center", Menu::Center),
      value("Right", Menu::Right),
      value("Top", Menu::Top),
      value("Middle", Menu::Middle),
      value("Bottom", Menu::Bottom)
      ]
     .def(constructor<const Rect<long>&, Menu::Align>())
     .def("setButtonStep", &Menu::setButtonStep)
     .def("addButton", &Menu::addButton)
     .def("setEnableNoSelect", &Menu::setEnableNoSelect)
     .def("setEnableRotate", &Menu::setEnableRotate)
     .def("setIndex", &Menu::setIndex)
     .def("isClicked", &Menu::isClicked)
     .def("clickedId", &Menu::clickedId),

     class_<ChatMessage, Component>("ChatMessage")
     .def(constructor<Font&, const Rect<long>&>())
     .def("setPosition", &ChatMessage::setPosition)
     .def("position", &ChatMessage::position)
     .def("setDrawTimeout", &ChatMessage::setDrawTimeout)
     .def("setFadeoutTime", &ChatMessage::setFadeoutTime)
     .def("setOffset", &ChatMessage::setOffset)
     .def("clear", &ChatMessage::clear)
     .def("print", &ChatMessage::print)
     .def("newline", &ChatMessage::newline),

     def("left", (long(*)(const Component&, long))&left),
     def("center", (long(*)(const Component&, long))&center),
     def("right", (long(*)(const Component&, long))&right),
     def("top", (long(*)(const Component&, long))&top),
     def("middle", (long(*)(const Component&, long))&middle),
     def("bottom", (long(*)(const Component&, long))&bottom),

     def("left", (long(*)(const Surface&, long))&left),
     def("center", (long(*)(const Surface&, long))&center),
     def("right", (long(*)(const Surface&, long))&right),
     def("top", (long(*)(const Surface&, long))&top),
     def("middle", (long(*)(const Surface&, long))&middle),
     def("bottom", (long(*)(const Surface&, long))&bottom)
     ];

  LuaHandler::registerValue(L, "SDLK_BACKSPACE", SDLK_BACKSPACE);
  LuaHandler::registerValue(L, "SDL_KEYDOWN", SDL_KEYDOWN);
  LuaHandler::registerValue(L, "KMOD_NONE", KMOD_NONE);
}
