/*!
  \file
  \brief Lua への AUDIO モジュール登録

  \author Satofumi KAMIMURA

  $Id: luabindAudio.cpp 921 2009-05-22 23:19:16Z satofumi $
*/

#include "luabindAudio.h"
#include "SoundEffect.h"
#include <luabind/luabind.hpp>

using namespace qrk;
using namespace luabind;


void qrk::luabindAudio(lua_State* L)
{
  module(L)
    [
     class_<SoundEffect>("SoundEffect")
     .def(constructor<const char*>())
     .def("play", &SoundEffect::play)
     .def("updatePosition", &SoundEffect::updatePosition)
     .def("isPlaying", &SoundEffect::isPlaying)
     ];
}
