#ifndef QRK_LUA_HANDLER_H
#define QRK_LUA_HANDLER_H

/*!
  \file
  \brief Lua の補助

  \author Satofumi KAMIMURA

  $Id: LuaHandler.h 1414 2009-10-14 23:14:02Z satofumi $
*/

#include <lua.hpp>


namespace qrk
{
  /*!
    \brief Lua の補助クラス
  */
  class LuaHandler
  {
  public:
    LuaHandler(void);
    ~LuaHandler(void);

    static lua_State* pointer(void);
    static lua_State* newthread(lua_State* L);
    static void addPath(lua_State* L, const char* additional_path);
    static int dofile(lua_State* L, const char* lua_file);
    static int dostring(lua_State* L, const char* lua_string);
    static void registerValue(lua_State* L, const char* name, int value);

  private:
    LuaHandler(const LuaHandler& rhs);
    LuaHandler& operator = (const LuaHandler& rhs);

    struct pImpl;
    pImpl* pimpl;
  };
}

#endif /* !QRK_LUA_HANDLER_H */
