/*!
  \example drawText.cpp
  \brief テキストの描画サンプル

  \author Satofumi KAMIMURA

  $Id: drawText.cpp 706 2009-04-03 03:07:55Z satofumi $
*/

#include "Screen.h"
#include "Font.h"
#include "TextSurface.h"
#include <vector>

using namespace qrk;
using namespace std;


int main(int argc, char *argv[])
{
  Screen screen;
  screen.show(SDL_OPENGL);

  // フォントの読み出し
  const char* font_file = (argc <= 1) ? "font.ttf" : argv[1];

  // サイズを変更しながらフォントを描画する
  int font_size[] = { 16, 32, 64 };

  vector<Surface*> surfaces;
  int y = 0;
  size_t n = sizeof(font_size) / sizeof(font_size[0]);
  for (size_t i = 0; i < n; ++i) {
    Font font(font_file, font_size[i]);
    if (! font.resource()) {
      exit(1);
    }
    TextSurface* text = new TextSurface(font, "こんにちはー");
    surfaces.push_back(text);

    Rect<long> dest_rect = text->rect();
    dest_rect.y = y;
    text->draw(NULL, &dest_rect);
    y += dest_rect.h;
  }

  // 描画内容を反映させる
  SDL_GL_SwapBuffers();
  SDL_Delay(1000);

  for (vector<Surface*>::iterator it = surfaces.begin();
       it != surfaces.end(); ++it) {
    delete *it;
  }

  return 0;
}
