/*!
  \file
  \brief SDL_ttf の初期化

  \author Satofumi KAMIMURA

  $Id: SdlTtfInit.cpp 693 2009-03-29 16:35:28Z satofumi $
*/

#include "SdlInit.h"
#include "SdlTtfInit.h"
#include <SDL_ttf.h>

using namespace qrk;


struct SdlTtfInit::pImpl : private SdlInit
{
  static bool initialized_;


  void init(void)
  {
    if (initialized_ || (TTF_Init() < 0)) {
      return;
    }
    // !!! TTF_Quit() の呼び出しは、Font 管理資源の解放後に行うべき
    // !!! 現時点において、実装方法は不明
    //atexit(TTF_Quit);
    initialized_ = true;
  }
};
bool SdlTtfInit::pImpl::initialized_ = false;


SdlTtfInit::SdlTtfInit(void) : pimpl(new pImpl)
{
  pimpl->init();
}


SdlTtfInit::~SdlTtfInit(void)
{
}
