#ifndef QRK_MULTI_SURFACE_H
#define QRK_MULTI_SURFACE_H

/*!
  \file
  \brief 複数サーフェスの合成

  \author Satofumi KAMIMURA

  $Id: MultiSurface.h 897 2009-05-17 20:59:55Z satofumi $
*/

#include "Surface.h"
#include "Point.h"
#include <memory>

namespace qrk
{
  class MultiSurface : public Surface
  {
    MultiSurface(void);
    MultiSurface(const MultiSurface& rhs);
    MultiSurface& operator = (const MultiSurface& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;

  public:
    explicit MultiSurface(Surface& base_surface);
    ~MultiSurface(void);

    bool isValid(void) const;
    Rect<long> rect(void) const;
    void setAlpha(float alpha);
    float alpha(void) const;
    void draw(const Rect<long>* src, const Rect<long>* dest);

    void push_front(Surface& surface, const Point<long>& offset);
  };
}

#endif /* !QRK_MULTI_SURFACE_H */
