#ifndef QRK_MENU_H
#define QRK_MENU_H

/*!
  \file
  \brief メニュー

  \author Satofumi KAMIMURA

  $Id: Menu.h 899 2009-05-17 21:36:48Z satofumi $
*/

#include "Component.h"
#include <boost/signals.hpp>
#include <boost/integer_traits.hpp>


namespace qrk
{
  typedef boost::signal<void (size_t)> ButtonIdCallback;


  /*!
    \brief メニュー
  */
  class Menu : public Component
  {
    Menu(void);
    Menu(const Menu& rhs);
    Menu& operator = (const Menu& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;

  public:
    enum {
      InvalidIndex = -1,
      InvalidId = boost::integer_traits<int>::const_max,
    };

    typedef enum {
      Left = 0x01,
      Center = 0x02,
      Right = 0x04,

      Top = 0x10,
      Middle = 0x20,
      Bottom = 0x40,
    } Align;

    Menu(const Rect<long>& rect, Align align = Left);
    ~Menu(void);

    Rect<long> rect(void) const;
    void setEventAcceptable(bool acceptable);
    void setAlpha(float alpha);
    void draw(const Rect<long>& area);

    void setButtonStep(const Point<long>& step);
    void addButton(Component& button, size_t id);
    void removeButton(size_t id);
    void setButtonEnabled(size_t id, bool enable);

    void setEnableNoSelect(bool enable);
    void setEnableRotate(bool enable);

    bool empty(void);
    size_t size(void);

    void setFocus(size_t id);
    void press(size_t id);
    void release(size_t id);
    void release(void);

    void setIndex(int index);
    bool isClicked(void) const;
    size_t clickedId(void) const;
    int clickedIndex(void) const;

    void registerIconLabel(Component& icon_label, bool draw_front = true);
    void unregisterIconLabel(void);
    void setIconOffset(const Point<long>& offset);

    void connectPressedEvent(ButtonIdCallback::slot_type& slot);
  };
}

#endif /* !QRK_MENU_H */
