/*!
  \file
  \brief ラベル

  \author Satofumi KAMIMURA

  $Id: Label.cpp 857 2009-05-11 12:59:05Z satofumi $
*/

#include "Label.h"
#include "Surface.h"

using namespace qrk;


struct Label::pImpl
{
  Surface& surface_;


  pImpl(Surface& surface) : surface_(surface)
  {
  }


  void draw(const Rect<long>& area, const Point<long>& own_position) const
  {
    static_cast<void>(area);
    // !!! area を反映させる

    if (! surface_.isValid()) {
      return;
    }

    // 指定位置への Surface 描画
    Rect<long> draw_rect = surface_.rect();
    draw_rect.x = own_position.x;
    draw_rect.y = own_position.y;

    surface_.draw(NULL, &draw_rect);
  }
};


Label::Label(Surface& surface) : pimpl(new pImpl(surface))
{
}


Label::~Label(void)
{
}


Rect<long> Label::rect(void) const
{
  return pimpl->surface_.rect();
}


void Label::setEventAcceptable(bool acceptable)
{
  static_cast<void>(acceptable);
  // 入力イベントは扱わないため、実装しない
}


void Label::setAlpha(float alpha)
{
  pimpl->surface_.setAlpha(alpha);
}


void Label::draw(const Rect<long>& area)
{
  pimpl->draw(area, position());
}
