#ifndef QRK_EVENT_MANAGER_H
#define QRK_EVENT_MANAGER_H

/*!
  \file
  \brief イベント管理

  \author Satofumi KAMIMURA

  $Id: EventManager.h 742 2009-04-17 22:26:21Z satofumi $
*/

#include "Point.h"
#include <SDL.h>
#include <memory>


namespace qrk
{
  class Event;


  /*!
    \brief イベント管理
  */
  class EventManager
  {
    EventManager(const EventManager& rhs);
    EventManager& operator = (const EventManager& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;

  public:
    EventManager(void);
    ~EventManager(void);

    void clear(void);
    void insert(Event* event);
    void remove(Event* event);

    void checkKey(SDLKey key, Uint8 type, SDLMod mod, Uint16 unicode);
    void checkClick(Uint8 mouse_button, Uint8 type);
    void checkEnterCursor(const Point<long>& current,
                          const Point<long>& previous);
    void cursorMoved(void);
  };
}

#endif /* !QRK_EVENT_MANAGER_H */
