#ifndef QRK_COLOR_SURFACE_H
#define QRK_COLOR_SURFACE_H

/*!
  \file
  \brief 単色サーフェス

  \author Satofumi KAMIMURA

  $Id: ColorSurface.h 735 2009-04-15 22:44:04Z satofumi $
*/

#include "Surface.h"
#include <memory>


namespace qrk
{
  class Color;


  /*!
    \brief 単色サーフェス
  */
  class ColorSurface : public Surface
  {
    ColorSurface(const ColorSurface& rhs);
    ColorSurface& operator = (const ColorSurface& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;

  public:
    explicit ColorSurface(const Rect<long>& rect, const Color& color);
    ~ColorSurface(void);

    bool isValid(void) const;
    Rect<long> rect(void) const;
    void setAlpha(float alpha);
    float alpha(void) const;
    void draw(const Rect<long>* src, const Rect<long>* dest);
  };
}

#endif /* !QRK_COLOR_SURFACE_H */
