#ifndef QRK_CALLBACK_EVENT_H
#define QRK_CALLBACK_EVENT_H

/*!
  \file
  \brief イベント保持クラス

  \author Satofumi KAMIMURA

  $Id: CallbackEvent.h 892 2009-05-15 21:48:28Z satofumi $
*/

#include "Event.h"
#include "Rect.h"
#include <boost/signals.hpp>
#include <memory>


namespace qrk
{
  typedef boost::signal<void (void)> EventCallback;


  /*!
    \brief イベント保持クラス
  */
  class CallbackEvent : public Event
  {
    CallbackEvent(const Event& rhs);
    CallbackEvent& operator = (const Event& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;

  public:
    CallbackEvent(void);
    ~CallbackEvent(void);

    // !!! システム用
    void checkKey(SDLKey key, Uint8 type, SDLMod mod, Uint16 unicode);
    void checkClick(Uint8 mouse_button, Uint8 type);
    void checkEnterCursor(const Point<long>& current,
                          const Point<long>& previous);
    void cursorMoved(void);


    void setEventAcceptable(bool acceptable);
    void clearEvent(void);
    void key(Uint16 key, Uint8 type = SDL_KEYDOWN,
             Uint16 mod = KMOD_NONE, Uint16 unicode = '\0');
    void click(Uint8 mouse_button, Uint8 type = SDL_MOUSEBUTTONDOWN);
    void enterCursor(const Rect<long>& area, bool enter = true);
    void moveCursor(bool move);

    bool isActive(void);
    void setCallback(const EventCallback::slot_type& callback);
  };
}

#endif /* !QRK_CALLBACK_EVENT_H */
