#ifndef QRK_ALIGN_UTILS_H
#define QRK_ALIGN_UTILS_H

/*!
  \file
  \brief 位置揃え用の関数

  \author Satofumi KAMIMURA

  $Id: AlignUtils.h 921 2009-05-22 23:19:16Z satofumi $
*/

namespace qrk
{
  class Component;
  class Surface;


  extern long left(const Component& component, long x);
  extern long center(const Component& component, long x);
  extern long right(const Component& component, long x);

  extern long top(const Component& component, long y);
  extern long middle(const Component& component, long y);
  extern long bottom(const Component& component, long y);

  extern long left(const Surface& component, long x);
  extern long center(const Surface& component, long x);
  extern long right(const Surface& component, long x);

  extern long top(const Surface& component, long y);
  extern long middle(const Surface& component, long y);
  extern long bottom(const Surface& component, long y);
};

#endif /* !QRK_ALIGN_UTILS_H */
