/*!
  \example gpsCtrlSample.cpp

  \brief GpsCtrl の利用サンプル

  \author Satofumi KAMIMURA

  $Id: gpsCtrlSample.cpp 775 2009-05-05 08:05:45Z satofumi $
*/

#include "mGpsCtrl.h"
#include "NmeaData.h"
#include "delay.h"

using namespace qrk;


int main(int argc, char *argv[])
{
  mGpsCtrl gps(argc, argv);
  if (! gps.connect("/dev/usb/ttyUSB0", 4800)) {
    printf("GpsCtrl::connect: %s\n", gps.what());
    exit(1);
  }

  NmeaData nmea;
  bool origin_initialized = false;
  while (1) {
    delay(1000);
    gps.update(&nmea);

    if (! nmea.validPosition()) {
      continue;
    }

    if (! origin_initialized) {
      origin_initialized = true;
      nmea.setOrigin(nmea.latitude, nmea.longitude);
    }

    Position<long> position = nmea.position(nmea.latitude, nmea.longitude);
    printf("%ld\t%ld\n", position.x, position.y);
    fflush(stdout);
  }
}
